/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.MACAddress;
import apiipc.generated.enums.RstpPortState;
import apiipc.generated.enums.STPPortState;
import apiipc.ipc.IPCEvent;

public abstract class STPProcessEvent
extends IPCEvent {
    public EventType type;

    public STPProcessEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ROOT_CHANGED,
        STP_PORT_STATE_CHANGED,
        RSTP_PORT_STATE_CHANGED;

    }

    public static class RstpPortStateChanged
    extends STPProcessEvent {
        public String ownerSwitch;
        public Integer vlan;
        public Integer portNumber;
        public RstpPortState oldStatus;
        public RstpPortState newStatus;

        public RstpPortStateChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.RSTP_PORT_STATE_CHANGED;
            this.ownerSwitch = (String)iPCEventLTV.getEventParameters().get(0);
            this.vlan = (Integer)iPCEventLTV.getEventParameters().get(1);
            this.portNumber = (Integer)iPCEventLTV.getEventParameters().get(2);
            this.oldStatus = RstpPortState.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(3));
            this.newStatus = RstpPortState.fromIntValue((Integer)iPCEventLTV.getEventParameters().get(4));
        }

        public String toString() {
            return super.toString() + "\n\townerSwitch = " + this.ownerSwitch + "\n\tvlan = " + this.vlan + "\n\tportNumber = " + this.portNumber + "\n\toldStatus = " + (Object)((Object)this.oldStatus) + "\n\tnewStatus = " + (Object)((Object)this.newStatus);
        }
    }

    public static class StpPortStateChanged
    extends STPProcessEvent {
        public String ownerSwitch;
        public Integer vlan;
        public Integer portNumber;
        public STPPortState oldStatus;
        public STPPortState newStatus;

        public StpPortStateChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.STP_PORT_STATE_CHANGED;
            this.ownerSwitch = (String)iPCEventLTV.getEventParameters().get(0);
            this.vlan = (Integer)iPCEventLTV.getEventParameters().get(1);
            this.portNumber = (Integer)iPCEventLTV.getEventParameters().get(2);
            this.oldStatus = (STPPortState)((Object)iPCEventLTV.getEventParameters().get(3));
            this.newStatus = (STPPortState)((Object)iPCEventLTV.getEventParameters().get(4));
        }

        public String toString() {
            return super.toString() + "\n\townerSwitch = " + this.ownerSwitch + "\n\tvlan = " + this.vlan + "\n\tportNumber = " + this.portNumber + "\n\toldStatus = " + (Object)((Object)this.oldStatus) + "\n\tnewStatus = " + (Object)((Object)this.newStatus);
        }
    }

    public static class RootChanged
    extends STPProcessEvent {
        public String ownerSwitch;
        public Integer vlan;
        public MACAddress oldMac;
        public Integer oldPriority;
        public MACAddress newMac;
        public Integer newPriority;

        public RootChanged(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.ROOT_CHANGED;
            this.ownerSwitch = (String)iPCEventLTV.getEventParameters().get(0);
            this.vlan = (Integer)iPCEventLTV.getEventParameters().get(1);
            this.oldMac = (MACAddress)iPCEventLTV.getEventParameters().get(2);
            this.oldPriority = (Integer)iPCEventLTV.getEventParameters().get(3);
            this.newMac = (MACAddress)iPCEventLTV.getEventParameters().get(4);
            this.newPriority = (Integer)iPCEventLTV.getEventParameters().get(5);
        }

        public String toString() {
            return super.toString() + "\n\townerSwitch = " + this.ownerSwitch + "\n\tvlan = " + this.vlan + "\n\toldMac = " + this.oldMac + "\n\toldPriority = " + this.oldPriority + "\n\tnewMac = " + this.newMac + "\n\tnewPriority = " + this.newPriority;
        }
    }
}

